--Select all rows from the CustNew table, both before and after the INSERT
SELECT *
FROM CustNew
ORDER BY cust_id

--Execute the Stored Procedure
EXECUTE NewCustomer 'The Vine Tree', '121 Climber Avenue', 'Wyong'
EXECUTE NewCustomer 'Snow Cones', '121 Chilly Place', 'Hobart'
EXECUTE NewCustomer 'Airborne Moths', '77 Dark Cave Hollow', 'Adelaide'

--Delete the record with the Maximum cust_id
DECLARE @Max_id INTEGER
--BEGIN TRANSACTION			--commence the transaction block
--SAVE TRANSACTION Trans_1	--establish a Savepoint for the ROLLBACK
SELECT @Max_id = MAX(cust_id)
FROM CustNew
DELETE
FROM CustNew
WHERE cust_id = @Max_id
--apply an 'UNDO' to the transaction
--ROLLBACK TRANSACTION Trans_1
